/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item.tools;

import codechicken.lib.util.ItemUtils;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import morph.avaritia.handler.BlockBreakEvents;
import morph.avaritia.init.AvaritiaModContent;
import morph.avaritia.item.MatterClusterItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class InfinityHoeItem
extends HoeItem {
    public InfinityHoeItem(Item.Properties properties) {
        super(AvaritiaModContent.INFINITY_TIER, 20, 0.0f, properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (!this.attemptTillOp(context) && !level.m_8055_(context.m_8083_()).m_60713_(Blocks.f_50093_)) {
            return InteractionResult.FAIL;
        }
        Player player = context.m_43723_();
        if (player == null || player.m_6144_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos origin = context.m_8083_();
        int aoe_range = 4;
        BlockBreakEvents.enableItemCapture();
        for (BlockPos aoePos : BlockPos.m_121940_((BlockPos)origin.m_142082_(-aoe_range, 0, -aoe_range), (BlockPos)origin.m_142082_(aoe_range, 0, aoe_range))) {
            boolean up2OK;
            boolean canceled;
            boolean lowerBlockOk;
            if (aoePos.equals((Object)origin)) continue;
            BlockState aoeState = level.m_8055_(aoePos);
            boolean airOrReplaceable = level.m_46859_(aoePos) || aoeState.m_204336_(BlockTags.f_198158_);
            boolean bl = lowerBlockOk = level.m_8055_(aoePos.m_7495_()).m_60659_((BlockGetter)level, aoePos.m_7495_(), Direction.UP, SupportType.CENTER) || level.m_8055_(aoePos.m_7495_()).m_60713_(Blocks.f_50093_);
            if (airOrReplaceable && lowerBlockOk && (player.m_150110_().f_35937_ || player.m_150109_().m_36063_(new ItemStack((ItemLike)Items.f_42329_))) && !(canceled = ForgeEventFactory.onBlockPlace((Entity)player, (BlockSnapshot)BlockSnapshot.create((ResourceKey)level.m_46472_(), (LevelAccessor)level, (BlockPos)aoePos), (Direction)Direction.UP)) && (player.m_150110_().f_35937_ || this.consumeItem(Items.f_42329_, player.m_150109_()))) {
                level.m_46597_(aoePos, Blocks.f_50493_.m_49966_());
            }
            boolean canDropAbove = level.m_8055_(aoePos.m_7494_()).m_60713_(Blocks.f_50493_) || level.m_8055_(aoePos.m_7494_()).m_60713_(Blocks.f_50440_) || level.m_8055_(aoePos.m_7494_()).m_60713_(Blocks.f_50093_);
            boolean canRemoveAbove = canDropAbove || level.m_8055_(aoePos.m_7494_()).m_204336_(BlockTags.f_198158_);
            boolean bl2 = up2OK = level.m_46859_(aoePos.m_7494_().m_7494_()) || level.m_8055_(aoePos.m_7494_().m_7494_()).m_204336_(BlockTags.f_198158_);
            if (!level.m_46859_(aoePos.m_7494_()) && canRemoveAbove && up2OK) {
                if (!level.f_46443_ && canDropAbove) {
                    level.m_7967_((Entity)new ItemEntity(level, player.m_20185_(), player.m_20186_(), player.m_20189_(), new ItemStack((ItemLike)Blocks.f_50493_)));
                }
                level.m_7471_(aoePos.m_7494_(), false);
            }
            this.attemptTillOp(InfinityHoeItem.updateContext(context, aoePos));
        }
        BlockBreakEvents.stopItemCapture();
        Set<ItemStack> drops = BlockBreakEvents.getCapturedDrops();
        if (!level.f_46443_) {
            List<ItemStack> clusters = MatterClusterItem.makeClusters(drops);
            for (ItemStack cluster : clusters) {
                ItemUtils.dropItem((Level)level, (BlockPos)origin.m_7494_(), (ItemStack)cluster);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean attemptTillOp(UseOnContext context) {
        Pair pair;
        BlockPos blockpos;
        int hook = ForgeEventFactory.onHoeUse((UseOnContext)context);
        if (hook != 0) {
            return hook > 0;
        }
        Level level = context.m_43725_();
        BlockState toolModifiedState = level.m_8055_(blockpos = context.m_8083_()).getToolModifiedState(context, ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)InfinityHoeItem.m_150858_((BlockState)toolModifiedState));
        if (pair == null) {
            return false;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(context)) {
            Player player = context.m_43723_();
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(context);
                if (player != null) {
                    context.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(context.m_43724_()));
                }
            }
            return true;
        }
        return false;
    }

    public boolean consumeItem(Item target, Inventory inventory) {
        for (ItemStack item : inventory.f_35974_) {
            if (item.m_41619_() || !item.m_150930_(target)) continue;
            item.m_41774_(1);
            inventory.m_6596_();
            return true;
        }
        return false;
    }

    private static UseOnContext updateContext(UseOnContext context, BlockPos newPos) {
        BlockPos pos = context.m_8083_();
        Vec3 newLocation = context.m_43720_().m_82520_((double)(newPos.m_123341_() - pos.m_123341_()), (double)(newPos.m_123342_() - pos.m_123342_()), (double)(newPos.m_123343_() - pos.m_123343_()));
        return new UseOnContext(context.m_43725_(), context.m_43723_(), context.m_43724_(), context.m_43722_(), new BlockHitResult(newLocation, context.m_43719_(), newPos, context.m_43721_()));
    }

    public boolean m_41386_(DamageSource source) {
        return source == DamageSource.f_19317_;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.m_32059_() >= 0) {
            entity.m_32064_();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }
}

